/*******************************************************************************
*                         USB4ALLAPI Library Version 1.0                       *
*******************************************************************************/
#ifndef _MODULEMANAGER_H_
#define _MODULEMANAGER_H_

#include "iAdminHandlerLayer.h"
#include "U4ADefines.h"
#include "HandlerPackager.h"
#include "ModuleMap.h"
#include "iDescriptorLayer.h"
#include "Log.h"

class ModuleManager : public iAdminHandlerLayer {
    private:
        HandlerPackager *hp;
        ModuleMap *mm;
        iDescriptorLayer *dl;
        log *l;
    public:
        ModuleManager();
        ~ModuleManager();
        // Interface iHandlerLayer
        bool send(int, char *, int, int);
        char* receive(int, bool&, int&, int);
        bool configure(int, char *, int);
        // Interface iAdminHandlerLayer
        int * getU4ABoards(int &);
        int requestEpIn(int, int);
        int requestEpOut(int, int);
        void registerModule(int, int, int, int, int);
        void unregisterModule(int);
        void unregisterAllModules(int);
        bool existsModule(int);
        int getSerialNumber(int);
        int getHandlerID(int);
        int buildModuleID(int, int);
};

#endif
